/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.INetwork;
import com.raoulvdberge.refinedstorage.api.util.StackListEntry;
import com.raoulvdberge.refinedstorage.api.util.StackListResult;
import com.raoulvdberge.refinedstorage.gui.GuiBase;
import com.raoulvdberge.refinedstorage.gui.grid.GuiGrid;
import com.raoulvdberge.refinedstorage.gui.grid.stack.IGridStack;
import com.raoulvdberge.refinedstorage.util.StackUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;

public class MessageGridFluidDelta
implements IMessage,
IMessageHandler<MessageGridFluidDelta, IMessage> {
    @Nullable
    private INetwork network;
    private List<StackListResult<FluidStack>> deltas;
    private List<Pair<IGridStack, Long>> clientDeltas;

    public MessageGridFluidDelta(@Nullable INetwork network, List<StackListResult<FluidStack>> deltas) {
        this.network = network;
        this.deltas = deltas;
    }

    public MessageGridFluidDelta() {
    }

    public void fromBytes(ByteBuf buf) {
        int size = buf.readInt();
        this.clientDeltas = new ArrayList<Pair<IGridStack, Long>>(size);
        for (int i = 0; i < size; ++i) {
            long delta = buf.readLong();
            this.clientDeltas.add((Pair<IGridStack, Long>)Pair.of((Object)StackUtils.readFluidGridStack(buf), (Object)delta));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.deltas.size());
        for (StackListResult<FluidStack> delta : this.deltas) {
            buf.writeLong(delta.getChange());
            StackListEntry<FluidStack> craftingEntry = this.network.getFluidStorageCache().getCraftablesList().getEntry(delta.getStack(), 2);
            StackUtils.writeFluidGridStack(buf, delta.getStack(), 0L, delta.getId(), craftingEntry != null ? craftingEntry.getId() : null, false, this.network.getFluidStorageTracker().get(delta.getStack()));
        }
    }

    public IMessage onMessage(MessageGridFluidDelta message, MessageContext ctx) {
        GuiBase.executeLater(GuiGrid.class, grid -> message.clientDeltas.forEach(p -> grid.getView().postChange((IGridStack)p.getLeft(), (Long)p.getRight())));
        return null;
    }
}

